<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model 
{

    protected $table = 'vehicles';
    public $timestamps = true;

    public function favourites()
    {
        return $this->hasOne('Favourite');
    }

    public function owner()
    {
        return $this->belongsTo('User');
    }

    public function enquiries()
    {
        return $this->hasMany('Enquiry');
    }

    public function HpiCheck()
    {
        return $this->hasOne('HpiCheck');
    }

    public function vehicleAttributeValues()
    {
        return $this->hasMany('VehicleAttributeValue');
    }

}